-- mods/nickel/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("nickel")

-- Lapis Lazuli Ore
minetest.register_node("nickel:stone_with_nickel", {
	description = S("nickel Ore"),
	tiles = {"default_stone.png^nickel_mineral_nickel.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'nickel:nickel 2'},  --The first and second drops ever
			},
			{
				items = {'nickel:nickel'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'nickel:nickel'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'nickel:nickel'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("nickel:nickel", {
	description = S("nickel"),
	inventory_image = "nickel.png",
})

-- Lapis Block
minetest.register_node("nickel:nickelblock", {
	description = S("nickel Block"),
	tiles = {"nickel_nickelblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'nickel:nickel',
	recipe = {
		{'nickel:nickel', 'nickel:nickel', 'nickel:nickel'},
		{'nickel:nickel', 'nickel:nickel', 'nickel:nickel'},
		{'nickel:nickel', 'nickel:nickel', 'nickel:nickel'},
	}
})

minetest.register_craft({
	output = 'nickel:nickel 9',
	recipe = {
		{'nickel:nickel'},
	}
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "nickel:stone_with_nickel",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "nickel:stone_with_nickel",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


